/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.container.standalone;

import java.util.ArrayList;
import java.util.Collection;
import org.sonar.api.SonarPlugin;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.batch.rule.Rule;
import org.sonar.api.batch.rule.Rules;
import org.sonar.api.rule.RuleKey;
import org.sonar.api.server.rule.RulesDefinition;
import org.sonar.api.utils.System2;
import org.sonar.api.utils.UriReader;
import org.sonarsource.sonarlint.core.client.api.common.RuleDetails;
import org.sonarsource.sonarlint.core.client.api.common.analysis.AnalysisResults;
import org.sonarsource.sonarlint.core.client.api.common.analysis.IssueListener;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneAnalysisConfiguration;
import org.sonarsource.sonarlint.core.client.api.standalone.StandaloneGlobalConfiguration;
import org.sonarsource.sonarlint.core.container.ComponentContainer;
import org.sonarsource.sonarlint.core.container.analysis.AnalysisContainer;
import org.sonarsource.sonarlint.core.container.analysis.DefaultAnalysisResult;
import org.sonarsource.sonarlint.core.container.global.DefaultRuleDetails;
import org.sonarsource.sonarlint.core.container.global.ExtensionInstaller;
import org.sonarsource.sonarlint.core.container.global.GlobalTempFolderProvider;
import org.sonarsource.sonarlint.core.container.standalone.StandalonePluginIndexProvider;
import org.sonarsource.sonarlint.core.container.standalone.rule.StandaloneRuleRepositoryContainer;
import org.sonarsource.sonarlint.core.plugin.DefaultPluginJarExploder;
import org.sonarsource.sonarlint.core.plugin.DefaultPluginRepository;
import org.sonarsource.sonarlint.core.plugin.PluginClassloaderFactory;
import org.sonarsource.sonarlint.core.plugin.PluginCopier;
import org.sonarsource.sonarlint.core.plugin.PluginInfo;
import org.sonarsource.sonarlint.core.plugin.PluginLoader;
import org.sonarsource.sonarlint.core.plugin.cache.PluginCacheProvider;

public class StandaloneGlobalContainer
extends ComponentContainer {
    private Rules rules;
    private ActiveRules activeRules;
    private RulesDefinition.Context rulesDefinitions;

    public static StandaloneGlobalContainer create(StandaloneGlobalConfiguration globalConfig) {
        StandaloneGlobalContainer container = new StandaloneGlobalContainer();
        container.add(globalConfig);
        container.add(new StandalonePluginIndexProvider(globalConfig.getPluginUrls()));
        return container;
    }

    @Override
    protected void doBeforeStart() {
        this.add(DefaultPluginRepository.class, PluginCopier.class, PluginLoader.class, PluginClassloaderFactory.class, DefaultPluginJarExploder.class, ExtensionInstaller.class, new GlobalTempFolderProvider(), UriReader.class, new PluginCacheProvider(), System2.INSTANCE);
    }

    @Override
    protected void doAfterStart() {
        this.installPlugins();
        this.loadRulesAndActiveRulesFromPlugins();
    }

    protected void installPlugins() {
        DefaultPluginRepository pluginRepository = this.getComponentByType(DefaultPluginRepository.class);
        for (PluginInfo pluginInfo : pluginRepository.getPluginInfos()) {
            SonarPlugin instance = pluginRepository.getPluginInstance(pluginInfo.getKey());
            this.addExtension(pluginInfo, instance);
        }
    }

    private void loadRulesAndActiveRulesFromPlugins() {
        StandaloneRuleRepositoryContainer container = new StandaloneRuleRepositoryContainer(this);
        container.execute();
        this.rules = container.getRules();
        this.activeRules = container.getActiveRules();
        this.rulesDefinitions = container.getRulesDefinitions();
    }

    public AnalysisResults analyze(StandaloneAnalysisConfiguration configuration, IssueListener issueListener) {
        AnalysisContainer analysisContainer = new AnalysisContainer(this);
        analysisContainer.add(configuration);
        analysisContainer.add(issueListener);
        analysisContainer.add(this.rules);
        analysisContainer.add(this.activeRules);
        DefaultAnalysisResult defaultAnalysisResult = new DefaultAnalysisResult();
        analysisContainer.add(defaultAnalysisResult);
        analysisContainer.execute();
        return defaultAnalysisResult;
    }

    public RuleDetails getRuleDetails(String ruleKeyStr) {
        RuleKey ruleKey = RuleKey.parse(ruleKeyStr);
        Rule rule = this.rules.find(ruleKey);
        if (rule == null) {
            throw new IllegalArgumentException("Unable to find rule with key " + ruleKey);
        }
        RulesDefinition.Repository repo = this.rulesDefinitions.repository(rule.key().repository());
        return new DefaultRuleDetails(ruleKeyStr, rule.name(), rule.description(), rule.severity(), repo.language(), repo.rule(rule.key().rule()).tags());
    }

    public Collection<String> getActiveRuleKeys() {
        ArrayList<String> result = new ArrayList<String>();
        for (ActiveRule ar : this.activeRules.findAll()) {
            result.add(ar.ruleKey().toString());
        }
        return result;
    }
}

